## Debian Buildsystem

This is a buildsystem that creates the `rootfs` of the Linux system. It is designed for `deb/APT`-based distros (Debian, Ubuntu, Linux Mint, etc).

### Required Packages

* binfmt-support
* qemu-arm-static
* debootstrap

There may be more...

### `createrootfs`

This script takes in a list of packages, some configuration options, and downloads and installs those packages to create the Linux system. It then creates a rootfs image from that so that the whole system can be put in one nice little file.

This script has two options, which must be run one after another as root to make a complete system for the HD2.

* `./createrootfs -r` - creates generic rootfs, without majority of customizations
* `./createrootfs -p` - customizes rootfs created by `./createrootfs -r` to suit HTC HD2

Run them as root with something like `./createrootfs -r && ./createrootfs -p`

### `options.conf`

This contains the options to be passed to the script. There are just a few:

* Filesystem Size: Sets the size of the filesystem image, in megabytes. Increase as needed.
* Repository/Mirror: Sets the server to download the packages from. The repository you pull from determines which distribution you are using.
* Hostname: Sets the network hostname of the computer: basically, it's nickname.
* Username: This sets the name of the user that will run the system. The script will also prompt you to set the root and user passwords, so it's good to set it to the same thing by default. The default is `htcleo`.

### `packages`

This contains the list of packages to be installed onto the system. You can find these package names by searching in the repositories of your Linux distro (ex: packages.debian.org). `APT` will also download all needed dependencies, so no need to worry about getting every single one.

### Wishlist

* **Done!** ArchISO style filesystem overlays
* Postinstall bash scripts to be run before build (for postinstall configuration)
* Automatically set root and user passwords from configuration file...

## AD SD System Design

This version of Linux is based on a configuration similar to that of Android on SDCard for HD2. There is an `initrd.gz` for startup, a `zImage` with the kernel, and a `rootfs.ext4` generated by the buildsystem. All of these files are to be put in a `debian` folder on the SDCard.

### initrd.gz

Contains all the basic system tools and the startup script to boot the system. It has a folder called `initrd` with an init script, and a whole bunch of binary tools in `bin`. A prebuilt one can be found in `sd-startup`.

### zImage

This contains the compressed binary image of the Linux kernel itself. This is generated by the custom kernel sources for the HD2 found [here](). A prebuilt one can be found in `sd-startup`.

### rootfs.ext4

This contains the system itself, and all that you would expect a Linux hard drive to have. It is created by the buildsystem. By default it is set to 1000 MB (~1 GB), but you can change this to something bigger while building. It is also possible to change the size afterwards by adding zeros to the image (link?).

## NativeSD System Design

It might be possible to move the system to the new NativeSD for greater speed and partitions larger than 4 GB (the limits of FAT filesizes). Perhaps a dual-boot with Android could be possible? Or we could use the Aroma Installer and the recovery? Needs research.

## Booting Linux from SDCard

Place the `initrd.gz`, `zImage`, and `rootfs.ext4` files in a `debian` folder, it is now possible to boot the system. Move the `debian` folder to the top folder of the SDCard and plug it into your HD2.

### MAGLDR

1. Turn on your phone and get to the bootloader menu. To do so, hold the power button until you see a menu.
2. Go to **Settings -> Boot Settings -> AD SD Dir** and set the boot directory to `debian`.
3. Go back to the bootloader menu and select **2. Boot AD SD** to start Linux.

### cLK

(needs instructions, check Installing Android to SD on cLK)

### HaRET

HaRET (Linux from Windows Mobile 6) might work too, but we're hard-pressed to find anyone that still uses poor little WM6, so contact us if it works or doesn't work.
